<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acesso - LBP</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: url('imagem/fundo.png') no-repeat center center fixed;
            background-size: cover;
            margin: 0;
            display: flex;
            align-items: center;
            justify-content: center;
            height: 93vh;
        }

        .login-container {
            background: linear-gradient(145deg, rgb(169, 169, 169), rgb(105, 105, 105));
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.9);
            padding: 30px 20px;
            width: 350px;
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .login-container img {
            width: 150px;
            margin-bottom: 1px;
        }

        .login-container h2 {
            color: #fff;
            margin-bottom: 5px;
        }

        .login-container input {
            width: 300px;
            padding: 22px;
            margin: 5px 0;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
        }

        .login-container button {
            background-color: #000000;
            color: #fff;
            padding: 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
            font-size: 16px;
            margin-top: 10px;
            position: relative;
            overflow: hidden;
            box-shadow: 0 0 10px rgba(255, 255, 255, 8.9);
            transition: box-shadow 0.1s ease-in-out;
        }

        .login-container button:hover {
            box-shadow: 0 0 20px rgba(255, 255, 255, 5.9);
        }

        .login-container button span {
            position: relative;
            z-index: 2;
        }

        .login-container p {
            color: #ff0000;
            font-size: 14px;
            margin-bottom: 30px;
        }

        .login-container .access-time {
            margin-top: 15px;
            color: #fff;
            font-size: 14px;
        }

        /* Estilos para o modal de erro */
        #errorModal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.8);
            align-items: center;
            justify-content: center;
            z-index: 1000;
        }

        #errorModal .modal-content {
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            width: 300px;
            text-align: center;
        }

        #errorModal h3 {
            color: #dc3545;
        }

        #errorModal button {
            background-color: #dc3545;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }

        /* Estilos do ícone de olho */
        .eye-icon {
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #007bff;
        }

    </style>
</head>

<body>
    <div class="login-container">
        <?php
        $caminhoArquivo = '.admin.db';
        if (!file_exists($caminhoArquivo)) {
            echo "<p><strong>[Atenção]</strong> Usuário e senha do Admin ainda não existem, digite o usuário e senha para criá-los.</p>";
        }
        ?>
        
        <!-- Imagem da Logo -->
        <img src="imagem/logo.png" alt="Logo">
        
        <h2>Insira seus dados de acesso</h2>
        <!-- Inclua o link do Font Awesome no <head> do seu documento HTML -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

        <form action="check.php" method="post">
            <div style="position: relative; margin-bottom: 10px;">
                <i class="fa fa-user" style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #007bff;"></i>
                <input type="text" name="usuario" placeholder="Nome de usuário" required style="padding-left: 30px; height: 35px;">
            </div>
            
            <div style="position: relative; margin-bottom: 10px;">
                <i class="fa fa-lock" style="position: absolute; left: 10px; top: 50%; transform: translateY(-50%); color: #dc3545;"></i>
                <input type="password" name="senha" id="senha" placeholder="Senha" required style="padding-left: 30px; height: 35px;">
                <!-- Ícone de olho -->
                <i class="fa fa-eye eye-icon" id="eyeIcon" onclick="togglePasswordVisibility()"></i>
            </div>

            <button type="submit"><span>ACESSAR</span></button>
        </form>

        <div class="access-time">
            <?php
            date_default_timezone_set('America/Manaus');
            echo "Chegada em: " . date('d/m/Y - H:i:s');
            ?>
        </div>
    </div>

    <!-- Modal de Erro -->
    <div id="errorModal">
        <div class="modal-content">
            <h3><i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Erro de acesso</h3>
            <p>Usuário ou senha incorretos.</p>
            <button onclick="closeModal()">TENTAR NOVAMENTE</button>
        </div>
    </div>

    <script>
        // Função para abrir o modal
        function openModal() {
            document.getElementById('errorModal').style.display = 'flex';
        }

        // Função para fechar o modal
        function closeModal() {
            document.getElementById('errorModal').style.display = 'none';
        }

        // Função para mostrar/ocultar a senha
        function togglePasswordVisibility() {
            var senha = document.getElementById('senha');
            var eyeIcon = document.getElementById('eyeIcon');
            if (senha.type === 'password') {
                senha.type = 'text';
                eyeIcon.classList.remove('fa-eye');
                eyeIcon.classList.add('fa-eye-slash');
            } else {
                senha.type = 'password';
                eyeIcon.classList.remove('fa-eye-slash');
                eyeIcon.classList.add('fa-eye');
            }
        }

        // Verifica o parâmetro de erro na URL
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.has('erro')) {
            openModal(); // Chama a função para abrir o modal de erro
        }
    </script>
</body>
</html>
