<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

// Função para sanitizar entradas de texto
function sanitizeInput($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

// Função para validar e criar um usuário
function criarUsuario($nome, $descricao, $whatsapp, $datavencimento, $datainicio, $servidor, $conexao, $nomedoapk, $macdoapk, $chavedoapk, $tipodedispositivo, $indicacao) {
    $db_check = new SQLite3('.listausuarios.db');
    
    // Verifica se o usuário já existe
    $stmt = $db_check->prepare('SELECT COUNT(*) AS total FROM USERS WHERE nome = :nome');
    $stmt->bindValue(':nome', $nome, SQLITE3_TEXT);
    $result = $stmt->execute()->fetchArray();

    if ($result['total'] > 0) {
        echo "<script>document.addEventListener('DOMContentLoaded', function() { new bootstrap.Modal(document.getElementById('modalClienteExistente')).show(); });</script>";
    } else {
        // Insere o novo usuário
        $stmt = $db_check->prepare('INSERT INTO USERS (nome, descricao, whatsapp, datavencimento, datainicio, servidor, conexao, nomedoapk, macdoapk, chavedoapk, tipodedispositivo, indicacao) VALUES (:nome, :descricao, :whatsapp, :datavencimento, :datainicio, :servidor, :conexao, :nomedoapk, :macdoapk, :chavedoapk, :tipodedispositivo, :indicacao)');
        $stmt->bindValue(':nome', $nome, SQLITE3_TEXT);
        $stmt->bindValue(':descricao', $descricao, SQLITE3_TEXT);
        $stmt->bindValue(':whatsapp', $whatsapp, SQLITE3_TEXT);
        $stmt->bindValue(':datavencimento', $datavencimento, SQLITE3_TEXT);
        $stmt->bindValue(':datainicio', $datainicio, SQLITE3_TEXT);
        $stmt->bindValue(':servidor', $servidor, SQLITE3_TEXT);
        $stmt->bindValue(':conexao', $conexao, SQLITE3_TEXT);
        $stmt->bindValue(':nomedoapk', $nomedoapk, SQLITE3_TEXT);
        $stmt->bindValue(':macdoapk', $macdoapk, SQLITE3_TEXT);
        $stmt->bindValue(':chavedoapk', $chavedoapk, SQLITE3_TEXT);
        $stmt->bindValue(':tipodedispositivo', $tipodedispositivo, SQLITE3_TEXT);
        $stmt->bindValue(':indicacao', $indicacao, SQLITE3_TEXT);

        if ($stmt->execute()) {
            echo "<script>document.addEventListener('DOMContentLoaded', function() { new bootstrap.Modal(document.getElementById('modalSucesso')).show(); });</script>";
        } else {
            echo "<script>alert('Erro ao criar o usuário.');</script>";
            echo "<script>window.location.href='criar.php';</script>";
        }
    }

    $db_check->close();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nome = sanitizeInput($_POST['nome']);
    $descricao = sanitizeInput($_POST['descricao']);
    $whatsapp = sanitizeInput($_POST['whatsapp']);
    $datavencimento = sanitizeInput($_POST['datavencimento']);
    $datainicio = sanitizeInput($_POST['datainicio']);
    $servidor = sanitizeInput($_POST['servidor']);
    $conexao = sanitizeInput($_POST['conexao']);
    $nomedoapk = sanitizeInput($_POST['nomedoapk']);
    $macdoapk = sanitizeInput($_POST['macdoapk']);
    $chavedoapk = sanitizeInput($_POST['chavedoapk']);
    $tipodedispositivo = sanitizeInput($_POST['tipodedispositivo']);
    $indicacao = sanitizeInput($_POST['indicacao']);

    // Chama a função para criar o usuário
    criarUsuario($nome, $descricao, $whatsapp, $datavencimento, $datainicio, $servidor, $conexao, $nomedoapk, $macdoapk, $chavedoapk, $tipodedispositivo, $indicacao);
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Criação</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f4f4;
            color: #333;
        }

        #sidebar {
            background-color: #343a40;
            color: #fff;
            height: 100vh;
        }

        #content {
            padding: 20px;
        }

        h1 {
            font-size: 2.5rem;
            text-align: center;
            color: #007bff;
            margin-bottom: 20px;
        }

        form {
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: auto;
        }

        form label {
            font-weight: bold;
            margin-bottom: 10px;
            color: #495057;
        }

        form input {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ced4da;
            border-radius: 15px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        form input:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
            outline: none;
        }

        form button {
            width: 100%;
            padding: 10px;
            background-color: #1C1C1C;
            color: #fff;
            border: none;
            border-radius: 10px;
            font-size: 1.0rem;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        form button:hover {
            background-color: #0000FF;
        }

        table {
            width: 100%;
            margin-top: 30px;
            border-collapse: collapse;
        }

        table th, table td {
            padding: 12px;
            text-align: left;
            border: 1px solid #dee2e6;
        }

        table th {
            background-color: #007bff;
            color: white;
        }

        @media (max-width: 768px) {
            form {
                padding: 20px;
            }

            h1 {
                font-size: 2rem;
            }
        }

        .modal-content {
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }
        
        /* Adicione isto ao seu CSS */
.modal-dialog {
    margin-top: 280px; /* Ajuste o valor conforme necessário */
}

        
        
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'laterais.php'; ?>
            <main role="main" class="col-md-9 col-lg-10 px-md-4" id="content">
                <h1>Página de Administração</h1>
                <form action="criar.php?token=criaruser" method="post">
                    <label for="nome"><i class="fa fa-user" style="color: #3498db;"></i> Nome do Cliente:</label>
                    <input type="text" id="nome" name="nome" required>
                    
                    <label for="whatsapp"><i class="fab fa-whatsapp" style="color: #25D366;"></i>
 Whatsapp:</label>
                    <input type="text" id="whatsapp" name="whatsapp">

                    <label for="descricao"><i class="fas fa-credit-card" style="color: #2ecc71;"></i> Valor:</label>
                    <input type="text" id="descricao" name="descricao">

                    <label for="datainicio"><i class="fas fa-calendar" style="color: #000080;"></i>
 Data de Início:</label>
                    <input type="date" id="datainicio" name="datainicio">

                    <label for="datavencimento"><i class="fas fa-calendar-day" style="color: #FF0000;"></i>
 Vencimento:</label>
                    <input type="date" id="datavencimento" name="datavencimento">

                    <label for="servidor"><i class="fas fa-server" style="color: #3498db;"></i> Servidor:</label>
                    <input type="text" id="servidor" name="servidor">

                    <label for="conexao"><i class="fas fa-network-wired" style="color: #FF00FF;"></i>
 Conexão:</label>
                    <input type="text" id="conexao" name="conexao">

                    <label for="nomedoapk"><i class="fas fa-mobile-alt" style="color: #3498db;"></i>
 Nome do APK:</label>
                    <input type="text" id="nomedoapk" name="nomedoapk">

                    <label for="macdoapk"><i class="fas fa-laptop" style="color: #9400D3;"></i>
 MAC do APK:</label>
                    <input type="text" id="macdoapk" name="macdoapk">

                    <label for="chavedoapk"><i class="fas fa-key" style="color: #8B4513;"></i>
 Chave do APK:</label>
                    <input type="text" id="chavedoapk" name="chavedoapk">

                    <label for="tipodedispositivo"><i class="fas fa-print" style="color: #363636;"></i>
 Tipo de Dispositivo:</label>
                    <input type="text" id="tipodedispositivo" name="tipodedispositivo">

                    <label for="indicacao"><i class="fas fa-star" style="color: #f39c12;"></i>
 Indicação:</label>
                    <input type="text" id="indicacao" name="indicacao">
                    

                    <button type="submit">Adicionar</button>
                </form>
            </main>
        </div>
    </div>

    <!-- Modal de Sucesso -->
    <div class="modal fade" id="modalSucesso" tabindex="-1" aria-labelledby="modalSucessoLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalSucessoLabel">Parabéns</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Cliente cadastrado com sucesso ✅
                </div>
                <div class="modal-footer">
                    <a href="listausuarios.php?option=iniciar" class="btn btn-primary">Fechar</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal de Erro -->
    <div class="modal fade" id="modalClienteExistente" tabindex="-1" aria-labelledby="modalClienteExistenteLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="modalClienteExistenteLabel">⚠️  Atenção</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Opa: este cliente já tem cadastro ⛔ 
                </div>
                <div class="modal-footer">
                    <a href="criar.php" class="btn btn-primary">Voltar</a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    
<!-- Script para formatar o MAC Address -->
    <script>
        document.getElementById('macdoapk').addEventListener('input', function(e) {
            let value = e.target.value.replace(/[^a-fA-F0-9]/g, ''); // Remove caracteres não alfanuméricos
            let formattedValue = value.toUpperCase().match(/.{1,2}/g); // Divide em pares de dois caracteres
            if (formattedValue) {
                e.target.value = formattedValue.join(':'); // Adiciona os dois pontos
            }
        });
    </script> 
    
</body>
</html>