<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

// Conectar ao banco de dados e contar os usuários vencidos
$db_check = new SQLite3('.listausuarios.db');

// Conta a quantidade de usuários vencidos
$sql_count = "SELECT COUNT(*) as total_vencidos FROM USERS WHERE DATE(datavencimento) <= DATE('now', '-0 days')";
$resultado_count = $db_check->query($sql_count);
$total_vencidos = $resultado_count->fetchArray(SQLITE3_ASSOC)['total_vencidos'];
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Gestor de clientes.">
    <meta name="keywords" content="gestor, cadastro, cliente">
    <meta name="author" content="Loboplay">
    <meta name="robots" content="index, follow">
    <link rel="icon" href="imagem/logo.png" type="image/png">
    <title>Clientes Inativos</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- FontAwesome CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f4f6f9;
            margin: 0;
            padding: 0;
        }
        
        #sidebar {
            background-color: #343a40;
            color: #fff;
            height: 100vh;
            padding-top: 20px;
        }
        
        #sidebar .nav-link {
            color: #fff;
            font-weight: 500;
        }
        
        #sidebar .nav-link:hover {
            color: #007bff;
            background-color: #495057;
        }
        
        #content {
            padding: 20px;
        }
        
        .page-title {
            text-align: center;
            margin-top: 1px;
            margin-bottom: 10px;
            font-size: 2rem;
            font-weight: 600;
            color: #343a40;
        }
        
        .search-bar {
            margin-bottom: 15px;
            position: relative;
        }

        .search-bar input {
            border: 2px solid #007bff;
            border-radius: 4px;
            padding: 10px;
            font-size: 1rem;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.8);
            transition: border-color 0.3s, box-shadow 0.3s;
        }

        .search-bar input:focus {
            border-color: #0056b3;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            outline: none;
        }
        
        .user-card {
            border-radius: 12px;
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.9);
            padding: 15px;
            margin-bottom: 20px;
            background-color: #fff;
            position: relative;
            overflow: hidden;
            transition: transform 0.3s, box-shadow 0.3s;
        }
        
        .user-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.9);
        }
        
        .user-card .status-icon {
            position: absolute;
            top: 1px;
            right: 5px;
            font-size: 1rem;
        }
        
        .user-card .icon-error {
            color: #f44336;
        }
        
        @media (max-width: 768px) {
            .user-card {
                padding: 15px;
                box-shadow: 0 4px 8px rgba(0, 0, 0, 0.9);
            }
            
            .user-card .status-icon {
                font-size: 1.5rem;
                top: 10px;
                right: 10px;
            }
        }
        
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <!-- Barra lateral -->
        <?php include 'laterais.php'; ?>

        <!-- Conteúdo principal -->
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-md-4" id="content">
            <center>
                <br>
                <h1 class="page-title">
                    <i class="fa fa-calendar" style="color: red;"></i> INATIVOS
                </h1>
                <p>
                    <i class="fas fa-users" style="color: blue;"></i> 
                    <span style="color: SaddleBrown;">Total de Usuários Inativos: <strong><?php echo $total_vencidos; ?></span></strong>
                </p>
            </center>

            <!-- Barra de pesquisa -->
            <div class="search-bar">
                <input type="text" id="searchInput" class="form-control" placeholder="Pesquisar usuário..." onkeyup="searchUser()">
            </div>

            <?php
            $sql_listar = 'SELECT * FROM USERS ORDER BY datavencimento DESC';
            $resultado = $db_check->query($sql_listar);

            if ($resultado) {
                echo '<div class="row">';
                while ($row = $resultado->fetchArray(SQLITE3_ASSOC)) {
                    $datavencimento = $row['datavencimento'];
                    
                    $dataAtual = new DateTime();
                    $dataVencimento = new DateTime($datavencimento);
                    
                    // Calcula a diferença em dias entre a data de vencimento e a data atual
                    $diferenca = $dataAtual->diff($dataVencimento)->days;

                    if ($dataVencimento > $dataAtual || $diferenca < 1) {
                        continue; // Pular usuários que não têm pelo menos 1 dia vencido
                    }

                    $status = "Vencido";
                    $statusColor = "#f44336";
                    $statusIconClass = "icon-error";

                    $data_datainicio = new DateTime($row['datainicio']);
                    $dataFormatada_datainicio = $data_datainicio->format('d/m/Y');
                    
                    $data_datavencimento = new DateTime($datavencimento);
                    $dataFormatada_datavencimento = $data_datavencimento->format('d/m/Y');  
                     
                    // Remove caracteres não numéricos do número de telefone
                    $apenasNumeros = preg_replace('/\D/', '', $row['whatsapp']);
                    
                    // Adiciona o código do país se necessário
                    $codigoPais = "55"; // Código do país para o Brasil
                    if (strlen($apenasNumeros) < 11) {
                        $apenasNumeros = $codigoPais . $apenasNumeros;
                    }
                    
                    $mensagem = urlencode("Olá *".$row['nome']."*, tudo bem? \n\nVerificando meu sistema e identifiquei seu cadastro como cliente. \n\nVocê era assinante e desde o dia *".$dataFormatada_datavencimento."* finalizou sua assinatura com a gente. \n\nQue tal reativarmos seu plano aqui na *LOBOPLAY* e voltar a ter todos os conteúdos novamente? \n\nCaso não tenha interesse, apenas ignore esta mensagem. \n\nAtt: *RICK* \n\nRede: *LOBOPLAY*  "); // Mensagem de envio
                    $whatsappLink = 'https://wa.me/' . htmlspecialchars($apenasNumeros) . '?text=' . $mensagem;

                    echo '<div class="col-md-4 mb-4">';
                    echo '<div class="user-card">';
                    echo '<div class="status-icon ' . $statusIconClass . '"><i class="fas fa-times-circle"></i></div>';
                    echo '<div class="card-body">';
                    echo '<center><h5 class="card-title"><p>👤 ' . htmlspecialchars($row['nome']) . '</h5>';
                    echo '<p class="card-text">✅ Ativado em: ' . htmlspecialchars($dataFormatada_datainicio) . '</p>';
                    echo '<p class="card-text">⛔ Expirado em: ' . htmlspecialchars($dataFormatada_datavencimento) . '</p>';
                    echo '<a href="' . $whatsappLink . '" class="btn btn-success" target="_blank"><i class="fab fa-whatsapp"></i> Enviar mensagem</a></center>';
                    echo '<a href="link_da_renovacao" class="btn btn-warning ml-2" target="_blank">Renovação Rápida</a>';  // Botão de renovação
                    echo '</center>';                    echo '</div>';
                    echo '</div>';
                    echo '</div>';
                }
                
            } else {
                echo '<p class="message-containerErro">Erro ao acessar o banco de dados.</p>';
            }
            ?>

        </main>
    </div>
</div>

<!-- Scripts do Bootstrap e FontAwesome -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/js/all.min.js"></script>

<!-- Função de pesquisa -->
<script>
    function searchUser() {
        var input, filter, cards, cardContainer, title, i;
        input = document.getElementById("searchInput");
        filter = input.value.toUpperCase();
        cardContainer = document.getElementsByClassName("row")[0];
        cards = cardContainer.getElementsByClassName("col-md-4");
        for (i = 0; i < cards.length; i++) {
            title = cards[i].getElementsByClassName("card-title")[0];
            if (title.innerHTML.toUpperCase().indexOf(filter) > -1) {
                cards[i].style.display = "";
            } else {
                cards[i].style.display = "none";
            }
        }
    }
</script>

</body>
</html>
