<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

// Função para sanitizar entradas de texto
function sanitizeInput($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

// Função para validar e criar um usuário
function criarUsuario($nome, $descricao, $whatsapp, $datavencimento, $datainicio, $servidor, $conexao, $nomedoapk, $macdoapk, $chavedoapk, $tipodedispositivo, $indicacao) {
    $db_check = new SQLite3('.listausuarios.db');
    
    // Verifica se o usuário já existe
    $stmt = $db_check->prepare('SELECT COUNT(*) AS total FROM USERS WHERE nome = :nome');
    $stmt->bindValue(':nome', $nome, SQLITE3_TEXT);
    $result = $stmt->execute()->fetchArray();

    if ($result['total'] > 0) {
        echo "<script>document.addEventListener('DOMContentLoaded', function() { new bootstrap.Modal(document.getElementById('modalClienteExistente')).show(); });</script>";
    } else {
        // Insere o novo usuário
        $stmt = $db_check->prepare('INSERT INTO USERS (nome, descricao, whatsapp, datavencimento, datainicio, servidor, conexao, nomedoapk, macdoapk, chavedoapk, tipodedispositivo, indicacao) VALUES (:nome, :descricao, :whatsapp, :datavencimento, :datainicio, :servidor, :conexao, :nomedoapk, :macdoapk, :chavedoapk, :tipodedispositivo, :indicacao)');
        $stmt->bindValue(':nome', $nome, SQLITE3_TEXT);
        $stmt->bindValue(':descricao', $descricao, SQLITE3_TEXT);
        $stmt->bindValue(':whatsapp', $whatsapp, SQLITE3_TEXT);
        $stmt->bindValue(':datavencimento', $datavencimento, SQLITE3_TEXT);
        $stmt->bindValue(':datainicio', $datainicio, SQLITE3_TEXT);
        $stmt->bindValue(':servidor', $servidor, SQLITE3_TEXT);
        $stmt->bindValue(':conexao', $conexao, SQLITE3_TEXT);
        $stmt->bindValue(':nomedoapk', $nomedoapk, SQLITE3_TEXT);
        $stmt->bindValue(':macdoapk', $macdoapk, SQLITE3_TEXT);
        $stmt->bindValue(':chavedoapk', $chavedoapk, SQLITE3_TEXT);
        $stmt->bindValue(':tipodedispositivo', $tipodedispositivo, SQLITE3_TEXT);
        $stmt->bindValue(':indicacao', $indicacao, SQLITE3_TEXT);

        if ($stmt->execute()) {
            echo "<script>document.addEventListener('DOMContentLoaded', function() { new bootstrap.Modal(document.getElementById('modalSucesso')).show(); });</script>";
        } else {
            echo "<script>alert('Erro ao criar o usuário.');</script>";
            echo "<script>window.location.href='criar.php';</script>";
        }
    }

    $db_check->close();

if (isset($_GET["option"]) && $_GET["option"] == "salvar") {
    $usuario = sanitizeInput($_POST['usuario']);
    $senha = sanitizeInput($_POST['senha']);

    if (!empty($usuario) && !empty($senha)) {
        criarUsuario($usuario, $senha);
    } else {
        echo "<script>alert('Erro: preencha todos os campos.');</script>";
    }
}

$db_check1 = new SQLite3('.admin.db');
$sql_check = 'SELECT * from USERS';
$ret_check = $db_check1->query($sql_check);

while ($row_check = $ret_check->fetchArray()) {
    $id_check = $row_check['id'];
    $NAME = $row_check['NAME'];
    $usuario = $row_check['USERNAME'];
    $senha = $row_check['PASSWORD'];
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ajuste de acesso</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f8f9fa;
            color: #333;
        }

        #sidebar {
            background-color: #343a40;
            color: #fff;
            height: 100vh;
        }

        #content {
            padding: 40px;
            background-color: #fff;
            border-radius: 15px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin-top: 20px;
        }

        h1 {
            font-size: 2.5rem;
            text-align: center;
            color: #007bff;
            margin-bottom: 40px;
        }

        p {
            text-align: center;
            font-size: 1.2rem;
            color: #6c757d;
            margin-bottom: 30px;
        }

        form {
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: auto;
        }

        form label {
            font-weight: bold;
            margin-bottom: 10px;
            color: #495057;
        }

        form input {
            width: 100%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ced4da;
            border-radius: 15px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }

        form input:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
            outline: none;
        }

        form button {
            width: 100%;
            padding: 10px;
            background-color: #000;
            color: #fff;
            border: none;
            border-radius: 5px;
            font-size: 1.2rem;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        form button:hover {
            background-color: #28a745;
        }

        @media (max-width: 768px) {
            form {
                padding: 20px;
            }

            h1 {
                font-size: 2rem;
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'laterais.php'; ?>
            <main role="main" class="col-md-9 col-lg-10 px-md-4" id="content">
                <h1>Área de ajuste de acesso</h1>
                <p>Gerencie seu acesso ao painel:</p>
                <form action="perfil.php?option=salvar" method="post">
                    <label for="usuario"><i class="fas fa-user"></i>
 Usuário:</label>
                    <input type="text" id="usuario" value="<?php echo $usuario; ?>" name="usuario" required>
                    
                    <label for="senha"><i class="fas fa-key"></i>
 Senha:</label>
                    <input type="text" id="senha" value="<?php echo $senha; ?>" name="senha" required>
                                        
                    <button type="submit">Atualizar</button>
                </form>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

<script>
document.addEventListener("DOMContentLoaded", function() {
    var macAddressInput = document.getElementById("macdoapk");

    macAddressInput?.addEventListener("input", function(e) {
        var value = e.target.value.replace(/[^a-fA-F0-9]/g, "").toUpperCase();
        var formattedValue = "";

        for (var i = 0; i < value.length; i++) {
            formattedValue += value[i];
            if ((i + 1) % 2 === 0 && i < value.length - 1) {
                formattedValue += ":";
            }
        }

        e.target.value = formattedValue;
    });
});
</script>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">

